﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Class_Library;
using System.Collections.Generic;

namespace Test_Framework
{
    [TestClass]
    public class tstAddressCollection
    {
        [TestMethod]
        public void InstanceOK()
        {
            //create an instance of the class we want to create
            clsAddressCollection AllAddresses = new clsAddressCollection();
            //test to see that it exists
            Assert.IsNotNull(AllAddresses);
        }

        [TestMethod]
        public void AddressListOK()
        {
            //create an instance of the class we want to create
            clsAddressCollection AllAddresses = new clsAddressCollection();
            //create some test data to assign to the property
            //in this case the data needs to be a list of objects
            List<clsAddress> TestList = new List<clsAddress>();
            //add an item to the list
            //create the item of test data
            clsAddress TestItem = new clsAddress();
            //set its properties
            TestItem.Active = true;
            TestItem.AddressID = 1;
            TestItem.CountyNo = 1;
            TestItem.DateAdded = DateTime.Now.Date;
            TestItem.HouseNo = "123a";
            TestItem.PostCode = "LE1 1WE";
            TestItem.Street = "some street";
            TestItem.Town = "some town";
            //add the item to the test list
            TestList.Add(TestItem);
            //assign the data to the property
            AllAddresses.AddressList = TestList;
            //test to see that the two values are the same
            Assert.AreEqual(AllAddresses.AddressList, TestList);
        }

        //[TestMethod]
        //public void CountPropertyOK()
        //{
        //    //create an instance of the class we want to create
        //    clsAddressCollection AllAddresses = new clsAddressCollection();
        //    //create some test data to assign to the property
        //    Int32 SomeCount = 2;
        //    //assign the data to the property
        //    AllAddresses.Count = SomeCount;
        //    //test to see that the two values are the same
        //    Assert.AreEqual(AllAddresses.Count, SomeCount);
        //}

        [TestMethod]
        public void ThisAddressPropertyOK()
        {
            //create an instance of the class we want to create
            clsAddressCollection AllAddresses = new clsAddressCollection();
            //create some test data to assign to the property
            clsAddress TestAddress = new clsAddress();
            //set the properties of the test object
            TestAddress.Active = true;
            TestAddress.AddressID = 1;
            TestAddress.CountyNo = 1;
            TestAddress.DateAdded = DateTime.Now.Date;
            TestAddress.HouseNo = "123a";
            TestAddress.PostCode = "LE1 1WE";
            TestAddress.Street = "some street";
            TestAddress.Town = "some town";
            //assign the data to the property
            AllAddresses.ThisAddress = TestAddress;
            //test to see that the two values are the same
            Assert.AreEqual(AllAddresses.ThisAddress, TestAddress);
        }

        [TestMethod]
        public void ListAndCountOK()
        {
            //create an instance of the class we want to create
            clsAddressCollection AllAddresses = new clsAddressCollection();
            //create some test data to assign to the property
            //in this case the data needs to be a list of objects
            List<clsAddress> TestList = new List<clsAddress>();
            //add an item to the list
            //create the item of test data
            clsAddress TestItem = new clsAddress();
            //set its properties
            TestItem.Active = true;
            TestItem.AddressID = 1;
            TestItem.CountyNo = 1;
            TestItem.DateAdded = DateTime.Now.Date;
            TestItem.HouseNo = "123a";
            TestItem.PostCode = "LE1 1WE";
            TestItem.Street = "some street";
            TestItem.Town = "some town";
            //add the item to the test list
            TestList.Add(TestItem);
            //assign the data to the property
            AllAddresses.AddressList = TestList;
            //test to see that the two values are the same
            Assert.AreEqual(AllAddresses.Count, TestList.Count);
        }

        //[TestMethod]
        //public void TwoRecordsPresent()
        //{
        //    //create an instance of the class we want to create
        //    clsAddressCollection AllAddresses = new clsAddressCollection();
        //    //test to see that the two values are the same
        //    Assert.AreEqual(AllAddresses.Count, 2);
        //}


        [TestMethod]
        public void AddMethodOK()
        {
            //create an instance of the class we want to create
            clsAddressCollection AllAddresses = new clsAddressCollection();
            //create the item of test data
            clsAddress TestItem = new clsAddress();
            //var to store the primary key
            Int32 PrimaryKey = 0;
            //set its properties
            TestItem.Active = true;
            TestItem.AddressID = 1;
            TestItem.CountyNo = 1;
            TestItem.DateAdded = DateTime.Now.Date;
            TestItem.HouseNo = "123a";
            TestItem.PostCode = "LE1 1WE";
            TestItem.Street = "some street";
            TestItem.Town = "some town";
            //set ThisAddress to the test data
            AllAddresses.ThisAddress = TestItem;
            //add the record
            PrimaryKey = AllAddresses.Add();
            //set the primary key of the test data
            TestItem.AddressID = PrimaryKey;
            //find the record
            AllAddresses.ThisAddress.Find(PrimaryKey);
            //test to see that the two values are the same
            Assert.AreEqual(AllAddresses.ThisAddress, TestItem);
        }

        [TestMethod]
        public void DeleteMethodOK()
        {
            //create an instance of the class we want to create
            clsAddressCollection AllAddresses = new clsAddressCollection();
            //create the item of test data
            clsAddress TestItem = new clsAddress();
            //var to store the primary key
            Int32 PrimaryKey = 0;
            //set its properties
            TestItem.Active = true;
            TestItem.AddressID = 1;
            TestItem.CountyNo = 1;
            TestItem.DateAdded = DateTime.Now.Date;
            TestItem.HouseNo = "123a";
            TestItem.PostCode = "LE1 1WE";
            TestItem.Street = "some street";
            TestItem.Town = "some town";
            //set ThisAddress to the test data
            AllAddresses.ThisAddress = TestItem;
            //add the record
            PrimaryKey = AllAddresses.Add();
            //set the primary key of the test data
            TestItem.AddressID = PrimaryKey;
            //find the record
            AllAddresses.ThisAddress.Find(PrimaryKey);
            //delete the record
            AllAddresses.Delete();
            //now find the record   
            Boolean Found = AllAddresses.ThisAddress.Find(PrimaryKey);
            //test to see that the record was not found
            Assert.IsFalse(Found);
        }


        [TestMethod]
        public void UpdateMethodOK()
        {
            //create an instance of the class we want to create
            clsAddressCollection AllAddresses = new clsAddressCollection();
            //create the item of test data
            clsAddress TestItem = new clsAddress();
            //var to store the primary key
            Int32 PrimaryKey = 0;
            //set its properties
            TestItem.Active = true;
            TestItem.CountyNo = 1;
            TestItem.DateAdded = DateTime.Now.Date;
            TestItem.HouseNo = "123a";
            TestItem.PostCode = "LE1 1WE";
            TestItem.Street = "some street";
            TestItem.Town = "some town";
            //set ThisAddress to the test data
            AllAddresses.ThisAddress = TestItem;
            //add the record
            PrimaryKey = AllAddresses.Add();
            //set the primary key of the test data
            TestItem.AddressID = PrimaryKey;
            //modify the test data
            TestItem.Active = false;
            TestItem.CountyNo = 3;
            TestItem.DateAdded = DateTime.Now.Date;
            TestItem.HouseNo = "123b";
            TestItem.PostCode = "LE2 2WE";
            TestItem.Street = "another street";
            TestItem.Town = "another town";
            //set the record based on the new test data
            AllAddresses.ThisAddress = TestItem;
            //update the record
            AllAddresses.Update();
            //find the record
            AllAddresses.ThisAddress.Find(PrimaryKey);
            //test to see ThisAddress matches the test data
            Assert.AreEqual(AllAddresses.ThisAddress, TestItem);
        }

        [TestMethod]
        public void ReportByPostCodeMethodOK()
        {
            //create an instance of the class containing unfiltered results
            clsAddressCollection AllAddresses = new clsAddressCollection();
            //create an instance of the filtered data
            clsAddressCollection FilteredAddresses = new clsAddressCollection();
            //apply a blank string (should return all records);
            FilteredAddresses.ReportByPostCode("");
            //test to see that the two values are the same
            Assert.AreEqual(AllAddresses.Count, FilteredAddresses.Count);
        }


        [TestMethod]
        public void ReportByPostCodeNoneFound()
        {
            //create an instance of the filtered data
            clsAddressCollection FilteredAddresses = new clsAddressCollection();
            //apply a post code that doesn't exist
            FilteredAddresses.ReportByPostCode("xxx xxx");
            //test to see that there are no records
            Assert.AreEqual(0, FilteredAddresses.Count);
        }

        [TestMethod]
        public void ReportByPostCodeTestDataFound()
        {
            //create an instance of the filtered data
            clsAddressCollection FilteredAddresses = new clsAddressCollection();
            //var to store outcome
            Boolean OK = true;
            //apply a post code that doesn't exist
            FilteredAddresses.ReportByPostCode("yyy yyy");
            //check that the correct number of records are found
            if (FilteredAddresses.Count == 2)
            {
                //check that the first record is ID 41
                if (FilteredAddresses.AddressList[0].AddressID != 41)
                {
                    OK = false;
                }
                //check that the first record is ID 43
                if (FilteredAddresses.AddressList[1].AddressID != 43)
                {
                    OK = false;
                }
            }
            else
            {
                OK = false;
            }
            //test to see that there are no records
            Assert.IsTrue(OK);
        }


    }
}
